/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_ElectricImplosionCompressor;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.StreamUtils;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class StaticRecipeChangeLoaders {
    private StaticRecipeChangeLoaders() {
    }

    public static void addEBFGasRecipes() {
        ArrayListMultimap<SubTag, GT_Recipe> toChange = StaticRecipeChangeLoaders.getRecipesToChange(WerkstoffLoader.NOBLE_GAS, WerkstoffLoader.ANAEROBE_GAS);
        StaticRecipeChangeLoaders.editRecipes(toChange, StaticRecipeChangeLoaders.getNoGasItems(toChange));
    }

    public static void fixEnergyRequirements() {
        GT_Recipe.GT_Recipe_Map.sMappings.stream().filter(StreamUtils::filterVisualMaps).forEach(gt_recipe_map -> gt_recipe_map.mRecipeList.parallelStream().forEach(gt_recipe -> {
            for (int i = 0; i < GT_Values.VN.length - 1; ++i) {
                if (gt_recipe.mEUt <= BW_Util.getMachineVoltageFromTier(i) || gt_recipe.mEUt > BW_Util.getTierVoltage(i)) continue;
                gt_recipe.mEUt = BW_Util.getMachineVoltageFromTier(i);
            }
        }));
    }

    private static void replaceWrongFluidOutput(Werkstoff werkstoff, GT_Recipe recipe, FluidStack wrongNamedFluid) {
        for (int i = 0; i < recipe.mFluidOutputs.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidOutputs[i], (FluidStack)wrongNamedFluid)) continue;
            recipe.mFluidOutputs[i] = werkstoff.getFluidOrGas(recipe.mFluidOutputs[i].amount);
        }
    }

    private static void replaceWrongFluidInput(Werkstoff werkstoff, GT_Recipe.GT_Recipe_Map map, GT_Recipe recipe, FluidStack wrongNamedFluid) {
        for (int i = 0; i < recipe.mFluidInputs.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidInputs[i], (FluidStack)wrongNamedFluid)) continue;
            Collection col = (Collection)map.mRecipeFluidMap.get(wrongNamedFluid.getFluid());
            map.mRecipeFluidMap.remove(wrongNamedFluid.getFluid());
            map.mRecipeFluidMap.put(werkstoff.getFluidOrGas(1).getFluid(), col);
            recipe.mFluidInputs[i] = werkstoff.getFluidOrGas(recipe.mFluidInputs[i].amount);
            map.mRecipeFluidNameMap.add(werkstoff.getFluidOrGas(1).getFluid().getName());
        }
    }

    private static void addConversionRecipe(Werkstoff werkstoff, FluidStack wrongNamedFluid) {
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, null, null, null, null, new FluidStack[]{wrongNamedFluid}, new FluidStack[]{werkstoff.getFluidOrGas(1)}, 1, 1, 0));
    }

    private static FluidStack getWrongNameFluid(Werkstoff werkstoff) {
        String name = werkstoff.getFluidOrGas(1).getFluid().getName();
        String wrongname = "molten." + name;
        return FluidRegistry.getFluidStack((String)wrongname, (int)1);
    }

    private static void enforceNobleGas(Werkstoff werkstoff) {
        FluidStack wrongNamedFluid = StaticRecipeChangeLoaders.getWrongNameFluid(werkstoff);
        if (wrongNamedFluid != null) {
            GT_Recipe.GT_Recipe_Map.sMappings.forEach(map -> map.mRecipeList.forEach(recipe -> {
                StaticRecipeChangeLoaders.replaceWrongFluidInput(werkstoff, map, recipe, wrongNamedFluid);
                StaticRecipeChangeLoaders.replaceWrongFluidOutput(werkstoff, recipe, wrongNamedFluid);
            }));
            StaticRecipeChangeLoaders.addConversionRecipe(werkstoff, wrongNamedFluid);
        }
    }

    public static void unificationRecipeEnforcer() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (!werkstoff.getGenerationFeatures().enforceUnification) continue;
            if (werkstoff.contains(WerkstoffLoader.NOBLE_GAS)) {
                StaticRecipeChangeLoaders.enforceNobleGas(werkstoff);
            }
            HashSet<String> oreDictNames = new HashSet<String>(werkstoff.getADDITIONAL_OREDICT());
            oreDictNames.add(werkstoff.getVarName());
            StaticRecipeChangeLoaders.runMoltenUnificationEnfocement(werkstoff);
            StaticRecipeChangeLoaders.runUnficationDeleter(werkstoff);
            for (String s : oreDictNames) {
                for (OrePrefixes prefixes : OrePrefixes.values()) {
                    if (OreDictionary.getOres((String)(prefixes + s)).size() <= 1) continue;
                    for (int j = 0; j < OreDictionary.getOres((String)(prefixes + s)).size(); ++j) {
                        ItemStack replacement;
                        ItemStack toReplace = (ItemStack)OreDictionary.getOres((String)(prefixes + s)).get(j);
                        if (GT_Utility.areStacksEqual((ItemStack)toReplace, (ItemStack)(replacement = werkstoff.get(prefixes))) || replacement == null || replacement.getItem() == null || toReplace == null) continue;
                        for (GT_Recipe.GT_Recipe_Map map : GT_Recipe.GT_Recipe_Map.sMappings) {
                            HashSet<GT_Recipe> toRem = new HashSet<GT_Recipe>();
                            for (GT_Recipe recipe : map.mRecipeList) {
                                int amount;
                                int i;
                                boolean removal = map.equals(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes) || map.equals(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                                for (i = 0; i < recipe.mInputs.length; ++i) {
                                    if (!GT_Utility.areStacksEqual((ItemStack)recipe.mInputs[i], (ItemStack)toReplace)) continue;
                                    if (removal) {
                                        toRem.add(recipe);
                                        continue;
                                    }
                                    amount = recipe.mInputs[i].stackSize;
                                    recipe.mInputs[i] = replacement.splitStack(amount);
                                }
                                for (i = 0; i < recipe.mOutputs.length; ++i) {
                                    if (!GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[i], (ItemStack)toReplace)) continue;
                                    if (removal) {
                                        toRem.add(recipe);
                                        continue;
                                    }
                                    amount = recipe.mOutputs[i].stackSize;
                                    recipe.mOutputs[i] = replacement.splitStack(amount);
                                }
                                if (!(recipe.mSpecialItems instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)((ItemStack)recipe.mSpecialItems), (ItemStack)toReplace)) continue;
                                if (removal) {
                                    toRem.add(recipe);
                                    continue;
                                }
                                int amount2 = ((ItemStack)recipe.mSpecialItems).stackSize;
                                recipe.mSpecialItems = replacement.splitStack(amount2);
                            }
                            map.mRecipeList.removeAll(toRem);
                        }
                    }
                }
            }
        }
    }

    private static void runMoltenUnificationEnfocement(Werkstoff werkstoff) {
        if (werkstoff.getGenerationFeatures().enforceUnification && werkstoff.getGenerationFeatures().hasMolten()) {
            try {
                FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(WerkstoffLoader.cellMolten), Materials.Empty.getCells(1));
                Field f = GT_Utility.class.getDeclaredField("sFilledContainerToData");
                f.setAccessible(true);
                Map sFilledContainerToData = (Map)f.get(null);
                HashSet torem = new HashSet();
                ItemStack toReplace = null;
                for (Map.Entry entry : sFilledContainerToData.entrySet()) {
                    String MODID = GameRegistry.findUniqueIdentifierFor((Item)data.filledContainer.getItem()).modId;
                    if (MODID.equals("bartworks") || MODID.equals("bartworkscrossmod") || !((FluidContainerRegistry.FluidContainerData)entry.getValue()).fluid.equals((Object)data.fluid) || ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer.equals(data.filledContainer)) continue;
                    toReplace = ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer;
                    torem.add(entry);
                }
                sFilledContainerToData.entrySet().removeAll(torem);
                torem.clear();
                if (toReplace != null) {
                    for (GT_Recipe.GT_Recipe_Map map : GT_Recipe.GT_Recipe_Map.sMappings) {
                        torem.clear();
                        for (GT_Recipe recipe : map.mRecipeList) {
                            int i;
                            for (i = 0; i < recipe.mInputs.length; ++i) {
                                if (!GT_Utility.areStacksEqual((ItemStack)recipe.mInputs[i], (ItemStack)toReplace)) continue;
                                torem.add(recipe);
                            }
                            for (i = 0; i < recipe.mOutputs.length; ++i) {
                                if (!GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[i], (ItemStack)toReplace)) continue;
                                torem.add(recipe);
                                if (map != GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes || !GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[i], (ItemStack)data.filledContainer) || recipe.mFluidInputs[0].equals((Object)data.fluid)) continue;
                                torem.add(recipe);
                            }
                            if (!(recipe.mSpecialItems instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)((ItemStack)recipe.mSpecialItems), (ItemStack)toReplace)) continue;
                            torem.add(recipe);
                        }
                        map.mRecipeList.removeAll(torem);
                    }
                }
                GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)data);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private static void runUnficationDeleter(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null) {
            werkstoff.getBridgeMaterial().mElement = Element.get((String)werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes)) continue;
            GT_OreDictUnificator.set((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)werkstoff.get(prefixes), (boolean)true, (boolean)true);
            for (ItemStack stack : OreDictionary.getOres((String)(prefixes + werkstoff.getVarName()))) {
                GT_OreDictUnificator.addAssociation((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)stack, (boolean)false);
                GT_OreDictUnificator.getAssociation((ItemStack)stack).mUnificationTarget = werkstoff.get(prefixes);
            }
        }
    }

    private static ArrayListMultimap<SubTag, GT_Recipe> getRecipesToChange(SubTag ... GasTags) {
        Iterator it = GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList.iterator();
        ArrayListMultimap toAdd = ArrayListMultimap.create();
        while (it.hasNext()) {
            String FluidString;
            Materials mat;
            GT_Recipe recipe = (GT_Recipe)it.next();
            if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (mat = Materials.get((String)((FluidString = recipe.mFluidInputs[0].getFluid().getName().replaceAll("molten", "").replaceAll("fluid", "")).substring(0, 1).toUpperCase() + FluidString.substring(1)))) == Materials._NULL) continue;
            for (SubTag tag : GasTags) {
                if (!mat.contains(tag)) continue;
                DebugLog.log("Found EBF Recipe to change, Output:" + BW_Util.translateGTItemStack(recipe.mOutputs[0]));
                toAdd.put((Object)tag, (Object)recipe);
            }
        }
        return toAdd;
    }

    private static HashSet<ItemStack> getNoGasItems(ArrayListMultimap<SubTag, GT_Recipe> base) {
        HashSet<ItemStack> toAdd = new HashSet<ItemStack>();
        ArrayListMultimap repToAdd = ArrayListMultimap.create();
        for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList) {
            for (SubTag tag : base.keySet()) {
                block2: for (GT_Recipe baseRe : base.get((Object)tag)) {
                    if (recipe.mInputs.length != baseRe.mInputs.length || recipe.mOutputs.length != baseRe.mOutputs.length) continue;
                    for (int i = 0; i < recipe.mInputs.length; ++i) {
                        if (recipe.mFluidInputs != null && recipe.mFluidInputs.length != 0 || !BW_Util.checkStackAndPrefix(recipe.mInputs[i]) || !BW_Util.checkStackAndPrefix(baseRe.mInputs[i]) || !GT_OreDictUnificator.getAssociation((ItemStack)recipe.mInputs[i]).mMaterial.mMaterial.equals(GT_OreDictUnificator.getAssociation((ItemStack)baseRe.mInputs[i]).mMaterial.mMaterial) || !GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[0], (ItemStack)baseRe.mOutputs[0])) continue;
                        toAdd.add(recipe.mOutputs[0]);
                        repToAdd.put((Object)tag, (Object)recipe);
                        continue block2;
                    }
                }
            }
        }
        base.putAll((Multimap)repToAdd);
        return toAdd;
    }

    private static void editEBFMaterialRecipes(SubTag GasTag, GT_Recipe recipe, Materials mat, HashSet<GT_Recipe> toAdd) {
        for (Materials materials : Materials.values()) {
            if (!materials.contains(GasTag)) continue;
            int time = (int)((double)recipe.mDuration / 200.0 * (200.0 + (materials.getProtons() >= mat.getProtons() ? (double)mat.getProtons() - (double)materials.getProtons() : (double)mat.getProtons() * 2.75 - (double)materials.getProtons())));
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{materials.getGas((long)recipe.mFluidInputs[0].amount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFWerkstoffRecipes(SubTag GasTag, GT_Recipe recipe, Materials mat, HashSet<GT_Recipe> toAdd) {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashMap.values()) {
            if (!werkstoff.contains(GasTag)) continue;
            int time = (int)((double)recipe.mDuration / 200.0 * (200.0 + (werkstoff.getStats().getProtons() >= mat.getProtons() ? (double)mat.getProtons() - (double)werkstoff.getStats().getProtons() : (double)mat.getProtons() * 2.75 - (double)werkstoff.getStats().getProtons())));
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.fluids.get((Object)werkstoff)), recipe.mFluidInputs[0].amount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFNoGasRecipes(GT_Recipe recipe, Materials mat, HashSet<GT_Recipe> toAdd, HashSet<ItemStack> noGas) {
        for (ItemStack is : noGas) {
            int circuitConfiguration = 1;
            if (!GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)recipe.mOutputs[0])) continue;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(recipe.mInputs.length);
            for (ItemStack stack : recipe.mInputs) {
                if (GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)11), (ItemStack)stack) || GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)14), (ItemStack)stack) || GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)19), (ItemStack)stack)) continue;
                if (BW_Util.checkStackAndPrefix(stack)) {
                    circuitConfiguration = (byte)(GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix.equals((Object)OrePrefixes.dustSmall) ? 4 : (GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix.equals((Object)OrePrefixes.dustTiny) ? 9 : 1));
                }
                inputs.add(stack);
            }
            inputs.add(GT_Utility.getIntegratedCircuit((int)circuitConfiguration));
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, inputs.toArray(new ItemStack[0]), recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, null, recipe.mFluidOutputs, (int)((double)recipe.mDuration / 200.0 * (200.0 + (double)mat.getProtons() * 2.75)), recipe.mEUt, recipe.mSpecialValue));
            break;
        }
    }

    private static void removeDuplicateGasRecipes(HashSet<GT_Recipe> toAdd) {
        HashSet<GT_Recipe> duplicates = new HashSet<GT_Recipe>();
        for (GT_Recipe recipe : toAdd) {
            for (GT_Recipe recipe2 : toAdd) {
                int i;
                if (recipe.mEUt != recipe2.mEUt || recipe.mDuration != recipe2.mDuration || recipe.mSpecialValue != recipe2.mSpecialValue || recipe == recipe2 || recipe.mInputs.length != recipe2.mInputs.length || recipe.mFluidInputs.length != recipe2.mFluidInputs.length) continue;
                boolean isSame = true;
                for (i = 0; i < recipe.mInputs.length; ++i) {
                    if (GT_Utility.areStacksEqual((ItemStack)recipe.mInputs[i], (ItemStack)recipe2.mInputs[i])) continue;
                    isSame = false;
                }
                for (i = 0; i < recipe.mFluidInputs.length; ++i) {
                    if (GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidInputs[i], (FluidStack)recipe2.mFluidInputs[i])) continue;
                    isSame = false;
                }
                if (!isSame) continue;
                duplicates.add(recipe2);
            }
        }
        toAdd.removeAll(duplicates);
    }

    private static Materials getMaterialFromInputFluid(GT_Recipe recipe) {
        String materialString = recipe.mFluidInputs[0].getFluid().getName().replaceAll("molten", "").replaceAll("fluid", "");
        return Materials.get((String)(materialString.substring(0, 1).toUpperCase() + materialString.substring(1)));
    }

    private static void editRecipes(ArrayListMultimap<SubTag, GT_Recipe> base, HashSet<ItemStack> noGas) {
        if (GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeFluidNameMap.contains(((Fluid)Objects.requireNonNull(WerkstoffLoader.fluids.get((Object)WerkstoffLoader.Oganesson))).getName())) {
            return;
        }
        HashSet<GT_Recipe> toAdd = new HashSet<GT_Recipe>();
        for (SubTag gasTag : base.keySet()) {
            for (GT_Recipe recipe : base.get((Object)gasTag)) {
                Materials mat;
                if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (mat = StaticRecipeChangeLoaders.getMaterialFromInputFluid(recipe)) == Materials._NULL) continue;
                StaticRecipeChangeLoaders.editEBFWerkstoffRecipes(gasTag, recipe, mat, toAdd);
                StaticRecipeChangeLoaders.editEBFMaterialRecipes(gasTag, recipe, mat, toAdd);
                StaticRecipeChangeLoaders.editEBFNoGasRecipes(recipe, mat, toAdd, noGas);
            }
            GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList.removeAll(base.get((Object)gasTag));
        }
        StaticRecipeChangeLoaders.removeDuplicateGasRecipes(toAdd);
        toAdd.forEach(arg_0 -> ((GT_Recipe.GT_Recipe_Map)GT_Recipe.GT_Recipe_Map.sBlastRecipes).add(arg_0));
    }

    public static void addElectricImplosionCompressorRecipes() {
        if (GT_TileEntity_ElectricImplosionCompressor.eicMap == null) {
            GT_TileEntity_ElectricImplosionCompressor.eicMap = new GT_Recipe.GT_Recipe_Map(new HashSet(GT_Recipe.GT_Recipe_Map.sImplosionRecipes.mRecipeList.size()), "gt.recipe.electricimplosioncompressor", "Electric Implosion Compressor", (String)null, "gregtech:textures/gui/basicmachines/Default", 1, 2, 1, 0, 1, "", 1, "", true, true);
            GT_Recipe.GT_Recipe_Map.sImplosionRecipes.mRecipeList.stream().filter(e -> e.mInputs != null).forEach(recipe -> GT_TileEntity_ElectricImplosionCompressor.eicMap.addRecipe(true, (ItemStack[])Arrays.stream(recipe.mInputs).filter(e -> !StaticRecipeChangeLoaders.checkForExplosives(e)).distinct().toArray(ItemStack[]::new), recipe.mOutputs, null, null, null, 1, BW_Util.getMachineVoltageFromTier(10), 0));
        }
    }

    private static boolean checkForExplosives(ItemStack input) {
        return GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)new ItemStack(Blocks.tnt)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)GT_ModHandler.getIC2Item((String)"industrialTnt", (long)1L)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)GT_ModHandler.getIC2Item((String)"dynamite", (long)1L)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)ItemList.Block_Powderbarrel.get(1L, new Object[0]));
    }
}

